-- Run once to add split extras and (optionally) migrate from old fields
ALTER TABLE bookings
  ADD COLUMN client_parking_fee DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER total_driver_price,
  ADD COLUMN client_waiting_fee DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER client_parking_fee,
  ADD COLUMN driver_parking_fee DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER client_waiting_fee,
  ADD COLUMN driver_waiting_fee DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER driver_parking_fee;

-- If you previously added parking_fee / extra_waiting_fee (single fields), migrate them to client-side (optional):
UPDATE bookings
SET client_parking_fee = IFNULL(parking_fee, 0.00),
    client_waiting_fee = IFNULL(extra_waiting_fee, 0.00)
WHERE (parking_fee IS NOT NULL OR extra_waiting_fee IS NOT NULL);

-- Keep old columns for backward compatibility (no DROP here).
-- Ensure completed_at exists (if you haven't added before)
ALTER TABLE bookings
  ADD COLUMN completed_at DATETIME NULL AFTER status;


-- Add flight number + fixed commission amount field on booking
-- If your MySQL doesn't support IF NOT EXISTS, run each ALTER separately
-- and skip any "duplicate column" errors.

ALTER TABLE bookings
  ADD COLUMN IF NOT EXISTS flight_number VARCHAR(50) NULL AFTER client_email,
  ADD COLUMN IF NOT EXISTS partner_commission_amount DECIMAL(10,2) NOT NULL DEFAULT 0.00 AFTER driver_waiting_fee;


