<?php
// includes/header.php
declare(strict_types=1);

require_once dirname(__DIR__) . '/config/functions.php';

// App name fallback if not defined in config.php
$appName = defined('APP_NAME') ? APP_NAME : 'CMRS';

// Session user + role (helper resolves from DB if needed)
$user     = current_user();
$roleName = user_role_name();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= e($appName) ?></title>
  <meta name="description" content="Internal dashboard for chauffeur bookings, rentals, and accounts." />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="<?= e(url_public('assets/css/style.css')) ?>" rel="stylesheet" />
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= e(url_public('index.php')) ?>"><?= e($appName) ?></a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#topNav" aria-controls="topNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div id="topNav" class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="<?= e(url_public('index.php')) ?>">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= e(url_modules('bookings/list.php')) ?>">Bookings</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= e(url_modules('drivers/list.php')) ?>">Drivers</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= e(url_modules('vehicles/list.php')) ?>">Vehicles</a></li>
        <li class="nav-item"><a class="nav-link" href <?= '"'.e(url_modules('rentals/list.php')).'"' ?>>Rentals</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= e(url_modules('invoices/list.php')) ?>">Invoices</a></li>
      </ul>

      <div class="d-flex align-items-center gap-3 text-white">
        <?php if (!empty($user)): ?>
          <span class="small">
            Signed in as <strong><?= e($user['full_name'] ?? $user['name'] ?? 'User') ?></strong>
            <?php if ($roleName): ?>
              <span class="badge text-bg-secondary ms-2"><?= e($roleName) ?></span>
            <?php endif; ?>
          </span>
          <a class="btn btn-sm btn-outline-light" href="<?= e(url_public('logout.php')) ?>">Logout</a>
        <?php else: ?>
          <a class="btn btn-sm btn-outline-light" href="<?= e(url_public('login.php')) ?>">Login</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</nav>

<div class="container-fluid">
  <div class="row">
    <aside class="col-12 col-md-3 col-xl-2 p-0 bg-white border-end">
      <?php include __DIR__ . '/sidebar.php'; ?>
    </aside>

    <main class="col-12 col-md-9 col-xl-10 p-3">
