<?php
declare(strict_types=1);
/**
 * includes/sidebar.php
 * Role-aware sidebar (Sales sees only Sales items)
 */

require_once dirname(__DIR__) . '/config/functions.php';

$u        = current_user();
$roleRaw  = (string)($u['role'] ?? $u['role_name'] ?? '');
$role     = normalize_role_name($roleRaw); // 'sales','md','accounts','admin','ops','management', etc.
$path     = (string)($_SERVER['REQUEST_URI'] ?? '');

/** active helper */
$active = function (array $needles) use ($path): string {
  foreach ($needles as $n) {
    if ($n !== '' && strpos($path, $n) !== false) return 'active';
  }
  return '';
};

/** Dashboard URL per role */
function dashboard_url_for_role_norm(string $role): string {
  switch ($role) {
    case 'sales':
      return url_modules('dashboard/sales.php');
    case 'md':
    case 'accounts':
    case 'management':
      return url_modules('dashboard/md.php');
    case 'admin':
      return url_public('index.php'); // system admin landing
    default:
      return url_public('index.php');
  }
}

$dashUrl    = dashboard_url_for_role_norm($role);
$dashNeedle = parse_url($dashUrl, PHP_URL_PATH) ?: '';
$dashActive = $active([$dashNeedle, '/public/index.php']);
?>
<aside class="border-end bg-white"
       style="min-width:240px; height:100vh; position:sticky; top:0; overflow-y:auto; overscroll-behavior:contain; -webkit-overflow-scrolling:touch;">

  <div class="p-3">
    <div class="d-flex align-items-center gap-2 mb-2">
      <div class="fw-bold"><?= e(APP_NAME ?? 'CMRS') ?></div>
      <span class="badge text-bg-light"><?= e(ucfirst($role)) ?></span>
    </div>

    <nav class="nav nav-pills flex-column gap-1">
      <!-- Dashboard -->
      <a class="nav-link <?= $dashActive ?>" href="<?= e($dashUrl) ?>">🏠 Dashboard</a>

      <?php if ($role === 'sales'): ?>
        <!-- SALES-ONLY MENU -->
        <div class="mt-2 small text-uppercase text-muted">Bookings</div>
        <a class="nav-link <?= $active(['/modules/bookings/list.php']) ?>"
           href="<?= e(url_modules('bookings/list.php')) ?>">📖 All Bookings</a>
        <a class="nav-link <?= $active(['/modules/bookings/add.php']) ?>"
           href="<?= e(url_modules('bookings/add.php')) ?>">➕ Add Booking</a>
        <a class="nav-link <?= $active(['/modules/bookings/calendar.php']) ?>"
           href="<?= e(url_modules('bookings/calendar.php')) ?>">📅 Calendar</a>

        <div class="mt-2 small text-uppercase text-muted">Sales & CRM</div>
        <a class="nav-link <?= $active(['/modules/partners/']) ?>"
           href="<?= e(url_modules('partners/list.php')) ?>">🤝 Partners</a>
        <a class="nav-link <?= $active(['/modules/corporates/']) ?>"
           href="<?= e(url_modules('corporates/list.php')) ?>">🏢 Corporate Accounts</a>
        <a class="nav-link <?= $active(['/modules/quotes/']) ?>"
           href="<?= e(url_modules('quotes/list.php')) ?>">🧾 Quotes</a>

      <?php elseif ($role === 'md' || $role === 'accounts' || $role === 'management'): ?>
        <!-- FINANCE-FOCUSED MENU -->
        <div class="mt-2 small text-uppercase text-muted">Operations</div>
        <a class="nav-link <?= $active(['/modules/bookings/list.php']) ?>"
           href="<?= e(url_modules('bookings/list.php')) ?>">📖 Bookings</a>
        <a class="nav-link <?= $active(['/modules/bookings/calendar.php']) ?>"
           href="<?= e(url_modules('bookings/calendar.php')) ?>">📅 Calendar</a>

        <div class="mt-2 small text-uppercase text-muted">Payments</div>
        <a class="nav-link <?= $active(['/modules/payments/drivers.php']) ?>"
           href="<?= e(url_modules('payments/drivers.php')) ?>">💷 Driver Payments</a>
        <a class="nav-link <?= $active(['/modules/payments/partners.php']) ?>"
           href="<?= e(url_modules('payments/partners.php')) ?>">🤝 Partner Payments</a>
        <a class="nav-link <?= $active(['/modules/payments/pending_payments.php']) ?>"
           href="<?= e(url_modules('payments/pending_payments.php')) ?>">⏳ Pending Payments</a>

        <div class="mt-2 small text-uppercase text-muted">Sales & CRM</div>
        <a class="nav-link <?= $active(['/modules/partners/']) ?>"
           href="<?= e(url_modules('partners/list.php')) ?>">🤝 Partners</a>
        <a class="nav-link <?= $active(['/modules/corporates/']) ?>"
           href="<?= e(url_modules('corporates/list.php')) ?>">🏢 Corporate Accounts</a>
        <a class="nav-link <?= $active(['/modules/quotes/']) ?>"
           href="<?= e(url_modules('quotes/list.php')) ?>">🧾 Quotes</a>

        <div class="mt-2 small text-uppercase text-muted">Finance</div>
        <a class="nav-link <?= $active(['/modules/invoices/']) ?>"
           href="<?= e(url_modules('invoices/list.php')) ?>">🧮 Invoices</a>
        <a class="nav-link <?= $active(['/modules/reports/']) ?>"
           href="<?= e(url_modules('reports/index.php')) ?>">📊 Reports</a>
        <a class="nav-link <?= $active(['/modules/accounts/index.php']) ?>"
           href="<?= e(url_modules('accounts/index.php')) ?>">📈 Accounts Dashboard</a>

        <div class="mt-2 small text-uppercase text-muted">Payroll</div>
        <a class="nav-link <?= $active(['/modules/payroll/staff/list.php']) ?>"
           href="<?= e(url_modules('payroll/staff/list.php')) ?>">👥 Staff</a>
        <a class="nav-link <?= $active(['/modules/payroll/staff/advances.php','/modules/payroll/staff/advance.php']) ?>"
           href="<?= e(url_modules('payroll/staff/advances.php')) ?>">💸 Advances</a>
        <a class="nav-link <?= $active(['/modules/payroll/staff/pay.php']) ?>"
           href="<?= e(url_modules('payroll/staff/pay.php')) ?>">🧾 Run Payroll</a>
        <a class="nav-link <?= $active(['/modules/payroll/history.php']) ?>"
           href="<?= e(url_modules('payroll/history.php')) ?>">📜 History</a>

      <?php else: ?>
        <!-- ADMIN / OTHER ROLES → FULL MENU -->
        <div class="mt-2 small text-uppercase text-muted">Bookings</div>
        <a class="nav-link <?= $active(['/modules/bookings/list.php']) ?>"
           href="<?= e(url_modules('bookings/list.php')) ?>">📖 All Bookings</a>
        <a class="nav-link <?= $active(['/modules/bookings/add.php']) ?>"
           href="<?= e(url_modules('bookings/add.php')) ?>">➕ Add Booking</a>
        <a class="nav-link <?= $active(['/modules/bookings/calendar.php']) ?>"
           href="<?= e(url_modules('bookings/calendar.php')) ?>">📅 Calendar</a>

        <div class="mt-2 small text-uppercase text-muted">Rentals</div>
        <a class="nav-link <?= $active(['/modules/rentals/list.php']) ?>"
           href="<?= e(url_modules('rentals/list.php')) ?>">🚗 Rental Contracts</a>

        <div class="mt-2 small text-uppercase text-muted">Fleet & Drivers</div>
        <a class="nav-link <?= $active(['/modules/vehicles/']) ?>"
           href="<?= e(url_modules('vehicles/list.php')) ?>">🚘 Vehicles</a>
        <a class="nav-link <?= $active(['/modules/drivers/']) ?>"
           href="<?= e(url_modules('drivers/list.php')) ?>">👤 Drivers</a>

        <div class="mt-2 small text-uppercase text-muted">Sales & CRM</div>
        <a class="nav-link <?= $active(['/modules/partners/']) ?>"
           href="<?= e(url_modules('partners/list.php')) ?>">🤝 Partners</a>
        <a class="nav-link <?= $active(['/modules/corporates/']) ?>"
           href="<?= e(url_modules('corporates/list.php')) ?>">🏢 Corporate Accounts</a>
        <a class="nav-link <?= $active(['/modules/quotes/']) ?>"
           href="<?= e(url_modules('quotes/list.php')) ?>">🧾 Quotes</a>

        <div class="mt-2 small text-uppercase text-muted">Payments</div>
        <a class="nav-link <?= $active(['/modules/payments/drivers.php']) ?>"
           href="<?= e(url_modules('payments/drivers.php')) ?>">💷 Driver Payments</a>
        <a class="nav-link <?= $active(['/modules/payments/partners.php']) ?>"
           href="<?= e(url_modules('payments/partners.php')) ?>">🤝 Partner Payments</a>
        <a class="nav-link <?= $active(['/modules/payments/pending_payments.php']) ?>"
           href="<?= e(url_modules('payments/pending_payments.php')) ?>">⏳ Pending Payments</a>

        <div class="mt-2 small text-uppercase text-muted">Finance</div>
        <a class="nav-link <?= $active(['/modules/invoices/']) ?>"
           href="<?= e(url_modules('invoices/list.php')) ?>">🧮 Invoices</a>
        <a class="nav-link <?= $active(['/modules/reports/']) ?>"
           href="<?= e(url_modules('reports/index.php')) ?>">📊 Reports</a>
        <a class="nav-link <?= $active(['/modules/accounts/index.php']) ?>"
           href="<?= e(url_modules('accounts/index.php')) ?>">📈 Accounts Dashboard</a>

        <div class="mt-2 small text-uppercase text-muted">Payroll</div>
        <a class="nav-link <?= $active(['/modules/payroll/staff/list.php']) ?>"
           href="<?= e(url_modules('payroll/staff/list.php')) ?>">👥 Staff</a>
        <a class="nav-link <?= $active(['/modules/payroll/staff/advances.php','/modules/payroll/staff/advance.php']) ?>"
           href="<?= e(url_modules('payroll/staff/advances.php')) ?>">💸 Advances</a>
        <a class="nav-link <?= $active(['/modules/payroll/staff/pay.php']) ?>"
           href="<?= e(url_modules('payroll/staff/pay.php')) ?>">🧾 Run Payroll</a>
        <a class="nav-link <?= $active(['/modules/payroll/history.php']) ?>"
           href="<?= e(url_modules('payroll/history.php')) ?>">📜 History</a>

        <div class="mt-2 small text-uppercase text-muted">System</div>
        <a class="nav-link <?= $active(['/public/index.php']) ?>"
           href="<?= e(url_public('index.php')) ?>">⚙️ System Admin</a>
      <?php endif; ?>

      <!-- Logout -->
      <div class="mt-3"></div>
      <a class="nav-link text-danger" href="<?= e(url_public('logout.php')) ?>">↩️ Logout</a>
    </nav>
  </div>
</aside>
