<?php
declare(strict_types=1);
/**
 * modules/suppliers/add.php
 */
require_once dirname(__DIR__, 2) . '/config/functions.php';
require_role(['Sales','SalesManager','Admin','Management']);

$user = current_user();
$cid  = (int)($user['company_id'] ?? 0);
if ($cid <= 0) redirect(url_public('login.php'));

$errors = [];
if ($_SERVER['REQUEST_METHOD']==='POST') {
  try {
    csrf_verify((string)($_POST['csrf'] ?? ''));
    $name  = trim((string)($_POST['name'] ?? ''));
    $email = trim((string)($_POST['email'] ?? ''));
    $phone = trim((string)($_POST['phone'] ?? ''));
    $notes = trim((string)($_POST['notes'] ?? ''));
    $active= (int)($_POST['is_active'] ?? 1);

    if ($name==='') throw new RuntimeException('Name is required.');

    $ins = db()->prepare("INSERT INTO suppliers
      (company_id, name, email, phone, notes, is_active, created_at, updated_at)
      VALUES (:cid,:n,:e,:p,:notes,:a,NOW(),NOW())");
    $ins->execute([
      ':cid'=>$cid, ':n'=>$name,
      ':e'=>$email!==''?$email:null,
      ':p'=>$phone!==''?$phone:null,
      ':notes'=>$notes!==''?$notes:null,
      ':a'=>$active===1?1:0
    ]);
    redirect(url_modules('suppliers/list.php'));
  } catch (Throwable $e) {
    $errors[] = (defined('APP_ENV') && APP_ENV==='dev') ? $e->getMessage() : 'Unable to save supplier.';
  }
}

include dirname(__DIR__, 2) . '/includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0">New Supplier</h1>
  <a class="btn btn-outline-secondary" href="<?= e(url_modules('suppliers/list.php')) ?>">Back</a>
</div>

<?php if ($errors): ?><div class="alert alert-danger"><ul class="mb-0"><?php foreach($errors as $er) echo '<li>'.e($er).'</li>'; ?></ul></div><?php endif; ?>

<div class="card shadow-sm">
  <div class="card-body">
    <form method="post" autocomplete="off" class="row g-3">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <div class="col-md-6">
        <label class="form-label">Name <span class="text-danger">*</span></label>
        <input class="form-control" name="name" required>
      </div>
      <div class="col-md-3">
        <label class="form-label">Email</label>
        <input type="email" class="form-control" name="email">
      </div>
      <div class="col-md-3">
        <label class="form-label">Phone</label>
        <input class="form-control" name="phone">
      </div>
      <div class="col-12">
        <label class="form-label">Notes</label>
        <textarea class="form-control" name="notes" rows="2"></textarea>
      </div>
      <div class="col-md-3">
        <label class="form-label">Status</label>
        <select class="form-select" name="is_active">
          <option value="1" selected>Active</option>
          <option value="0">Inactive</option>
        </select>
      </div>
      <div class="col-12 d-flex gap-2">
        <button class="btn btn-dark">Save</button>
        <a class="btn btn-outline-secondary" href="<?= e(url_modules('suppliers/list.php')) ?>">Cancel</a>
      </div>
    </form>
  </div>
</div>
<?php include dirname(__DIR__, 2) . '/includes/footer.php';
